import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Form, TextArea, Checkbox} from 'react-form';
import SpeciesChooser from "../Fields/SpeciesChooser/SpeciesChooser";
import Typeahead from "../Fields/Typeahead/Typeahead";
import Text from "../Fields/Text/Text";
import DateTime from "../Fields/DateTime/DateTime";
import {sitoNatura2000SmartFilterQuery} from "../../../api/queries";
import ReactTable from "react-table";
import Loading from "../../Loading/Loading";
import {withApollo} from "react-apollo";
import {findById} from "../../../utils";
import {withRouter} from "react-router-dom";
import InterventoDocumenti from "./InterventoDocumenti";
import Permissions from "../../../permissions";
import Select from "../Fields/Select/Select";

class InterventoFormComponent extends Component {

  constructor(props) {
    super(props);
    console.log(props)

  var bigJim = [
    {
        "label":"",
        "solotipo":"habitat",
        "children":[
	    {"id":"numero_intervento", "label":"N. intervento", "value":""},
	    {"id":"h_ente", "label":"Ente responsabile", "value":""},
	    {"id":"h_data_intervento", "label":"Data intervento", "value":""},
            {"id":"nome_habitat", "label":"Nome habitat", "value":""},
            
            {"id":"descrizione", "label":"Descrizione intervento", "value":""},
            {"id":"foto_pre", "label":"Foto pre intervento", "value":""},
            {"id":"foto_post", "label":"Foto post intervento", "value":""},
            {"id":"specie", "label":"Presenza specie target prima dell'intervento", "value":"", "type":"checkbox"},
            {"id":"idoneita_pre", "label":"Idoneita' habitat pre intervento (alta, media, bassa)", "value":""}
        ]
    },
     {
        "label":"Localizzazione",
        "solotipo":"habitat",
        "children":[
            {"id":"h_transetto", "label":"Transetto", "value":""},
            {"id":"coord_e_i", "label":"Coordinate E inizio intervento", "value":"", "cx":"true"},
            {"id":"coord_n_i", "label":"Coordinate N inizio intervento", "value":"", "cy":"true"},
            {"id":"coord_e_f", "label":"Coordinate E fine intervento", "value":""},
            {"id":"coord_n_f", "label":"Coordinate N fine intervento", "value":""},
            {"id":"alti", "label":"Altitudine (m)", "value":""},
            {"id":"tipo_ambi", "label":"Tipologia ambiente", "value":""},
            {"id":"localita", "label":"Localita' intervento", "value":""},
            {"id":"comune", "label":"Comune", "value":""},
            {"id":"gestore", "label":"Gestore", "value":""},
            {"id":"proprieta", "label":"Proprieta'", "value":""},
            {"id":"foglio", "label":"Foglio catastale", "value":""},
            {"id":"particella", "label":"Particella", "value":""}

        ]
    },
    {
        "label":"Albero habitat",
        "solotipo":"habitat",
        "solosottotipo":"albero",
        "children":[
            {"id":"albero_circ", "label":"Circonferenza albero (cm)", "value":""},
            {"id":"albero_cerc", "label":"Cercinatura", "value":"", "type":"checkbox"},
            {"id":"albero_semicerc", "label":"Semicercinatura", "value":"", "type":"checkbox"},
            {"id":"albero_pend", "label":"Albero morto pendente", "value":"", "type":"checkbox"},
            {"id":"albero_fusto", "label":"Fusto spezzato in piedi", "value":"", "type":"checkbox"},
            {"id":"albero_srad", "label":"Alberi sradicati", "value":"", "type":"checkbox"},
            {"id":"albero_spes", "label":"Fusto spezzato a terra", "value":"", "type":"checkbox"},
            {"id":"albero_catino", "label":"Catino basale", "value":"", "type":"checkbox"},
            {"id":"albero_catasta", "label":"Catasta a perdere", "value":"", "type":"checkbox"},
            {"id":"albero_trip", "label":"Tripode", "value":"", "type":"checkbox"},
            {"id":"albero_cv1", "label":"Cavitazione (grado 1, grado 2, grado 3)", "value":""},
            {"id":"albero_capit", "label":"Capitozzatura per favorire il processo naturale di cavitazione", "value":"", "type":"checkbox"},
            {"id":"albero_ampl", "label":"Ampliamento cavita' esistente su albero vivo", "value":"", "type":"checkbox"},
            {"id":"albero_capitt", "label":"Piantumazione di plantule di specie idonee ad una successiva capitozzatura", "value":"", "type":"checkbox"}
]},
    {
            "label":"Installazione WMB",
            "solotipo":"habitat",
            "solosottotipo":"albero",
            "children":[
           
	    {"id":"wmb_codice", "label":"Codice su WMB", "value":""},
            {"id":"wmb_opid", "label":"Operazioni per idoneita' installazione", "value":""},
            {"id":"wmb_alt", "label":"Altezza del fondo da terra (m)", "value":""},
            {"id":"wmb_esp", "label":"Esposizione", "value":""},
            {"id":"wmb_prof", "label":"Profondita'", "value":""},
            {"id":"wmb_larg", "label":"Larghezza", "value":""},
            {"id":"wmb_capac", "label":"Capacita'", "value":""},
            {"id":"wmb_diam", "label":"Diametro foro", "value":""},
            {"id":"wmb_datasubstr", "label":"Data inserimento substrato", "value":""},
            {"id":"wmb_datalarve", "label":"Data inserimento larve", "value":""},
            {"id":"wmb_larve3", "label":"Numero larve L3 inserite", "value":""},
            {"id":"wmb_datadulti", "label":"Data inserimento adulti", "value":""},
            {"id":"wmb_adulti", "label":"Numero adulti inseriti", "value":""}
]},
    {
            "label":"Interventi secondari",
            "solotipo":"habitat",
            "solosottotipo":"albero",
            "children":[
            {"id":"albero_srama", "label":"Sramatura", "value":""},
            {"id":"albero_potasup", "label":"Potatura rami superiori ombreggianti", "value":""},
            {"id":"albero_spollon", "label":"Spollonatura (abbattimento o diradamento polloni)", "value":""},
            {"id":"albero_dirad", "label":"Diradamento del sottobosco", "value":""},
            {"id":"albero_ripusot", "label":"Ripulitura sottobosco", "value":""},
            {"id":"albero_decesp", "label":"Decespugliamento", "value":""},
            {"id":"albero_altro", "label":"Altro", "value":""},
            {"id":"albero_raggio", "label":"Area raggio interventi secondari (m)", "value":""},
            {"id":"albero_note", "label":"Note", "value":""}
]},
    {
        "label":"Zona umida",
        "solotipo":"habitat",
        "solosottotipo":"lentica;lotica",
        "children":[
            {"id":"umida1", "label":"Decespugliamento selettivo (sponda/area)", "value":""},
            {"id":"umidax1", "label":"Estensione (m/mq)", "value":""},
            {"id":"umida2", "label":"Sfalcio vegetazione erbacea (sponda/area)", "value":""},
            {"id":"umidax2", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida3", "label":"Taglio piante arboree (sponda/area)", "value":""},
            {"id":"umidax3", "label":"Estensione (m/mq)", "value":""},
            {"id":"umida4", "label":"Riduzione canneto (sponda/area)", "value":""},
            {"id":"umidax4", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida5", "label":"Eliminazione canneto (sponda/area)", "value":""},
            {"id":"umidax5", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida6", "label":"Eliminazione piante esotiche (sponda/area, specie)", "value":""},
            {"id":"umidax6", "label":"Estensione (m/mq)", "value":""},
            {"id":"umida7", "label":"Piantumazione piante acquatiche (sponda/area, specie)", "value":""},
            {"id":"umidax7", "label":"Estensione (m/mq)", "value":""},	
            {"id":"umida8", "label":"Sfangamento (sponda/area, profondita')", "value":""},
            {"id":"umidax8", "label":"Estensione (m/mq)", "value":""},
            {"id":"umida9", "label":"Risagomatura (sponda/area)", "value":""},
            {"id":"umidax9", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida10", "label":"Recinzione (sponda/area)", "value":""},
            {"id":"umidax10", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida11", "label":"Altro (sponda/area)", "value":""},
            {"id":"umidax11", "label":"Estensione (m/mq)", "value":""},		
            {"id":"umida12", "label":"Note", "value":""}
]},
     {
        "label":"Monitoraggio intervento",
        "solotipo":"habitat",
        "add":"true",
        "hidden":"true",
        "children":[
            {"id":"num_monit", "label":"N. monitoraggio", "value":""},
            {"id":"op_monit", "label":"Operatore monitoraggio", "value":""},
            {"id":"data_monit", "label":"Data monitoraggio", "value":""},
            {"id":"ril_monit", "label":"Compilatore", "value":""},
            {"id":"foto_monit", "label":"Foto monitoraggio", "value":""},
            {"id":"idon_monit", "label":"Idoneita' habitat al controllo (alta, media, bassa)", "value":""},
	    {"id":"pres_monit", "label":"Presenza specie target al controllo", "type":"checkbox"},
            {"id":"m_monit", "label":"Esemplari M", "value":""},
            {"id":"f_monit", "label":"Esemplari F", "value":""},
            {"id":"i_monit", "label":"Esemplari I", "value":""},
            {"id":"am_monit", "label":"Esemplari adulti maturi", "value":""},
            {"id":"ai_monit", "label":"Esemplari adulti immaturi", "value":""},
            {"id":"l_monit", "label":"Larve", "value":""},
            {"id":"p_monit", "label":"Pupe", "value":""},
            {"id":"u_monit", "label":"Uova", "value":""},
            {"id":"ex_monit", "label":"Exuvie", "value":""},
            {"id":"acc_monit", "label":"Accoppiamento", "value":"", "type":"checkbox"},
            {"id":"dep_monit", "label":"Deposizione uova", "value":"", "type":"checkbox"},
            {"id":"resti_monit", "label":"Resti e pellet specie target", "value":"", 

"type":"checkbox"},
            {"id":"statosal_monit", "label":"Annotazioni sullo stato di salute", 

"value":""},
            {"id":"situ_monit", "label":"Riproduzione in situ", "value":"", 

"type":"checkbox"},
            {"id":"sah_monit", "label":"Stato albero habitat", "value":""},
            {"id":"wmb_monit", "label":"Stato WMB", "value":""},
            {"id":"cav_monit", "label":"Stato cavita'", "value":""},
            {"id":"tros_monit", "label":"Temperatura rosura a -20cm (C)", "value":""},
            {"id":"test_monit", "label":"Temperatura esterna (C)", "value":""},
            {"id":"umint_monit", "label":"Umidita' interna WMB (%)", "value":""},
            {"id":"umest_monit", "label":"Umidita' esterna", "value":""},
            {"id":"pred_monit", "label":"Presenza predatori", "value":""},
            {"id":"fung_monit", "label":"Presenza funghi", "value":""},
            {"id":"paras_monit", "label":"Presenza parassiti", "value":""},
            {"id":"muff_monit", "label":"Presenza muffe", "value":""},
            {"id":"altresp_monit", "label":"Altre specie", "value":""},
            {"id":"evol_monit", "label":"Evoluzione attesa", "value":"", 

"type":"checkbox"},
            {"id":"necess_monit", "label":"Necessita' nuovo intervento", "value":"", 

"type":"checkbox"},
            {"id":"oper_monit", "label":"Operazioni effettuate al controllo", 

"value":""},
            {"id":"esegui_monit", "label":"Interventi da eseguire", "value":""},
            {"id":"altreos_monit", "label":"Altre osservazioni al controllo", "value":""}
        ]
    },
     {
        "label":"Tipo intervento in natura",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_prelievo", "label":"Prelievo", "value":"", "type":"checkbox"},
            {"id":"pr_immissione", "label":"Immissione", "value":"", "type":"checkbox"}
        ]
    },
   {
        "label":"Informazioni generali",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_ente", "label":"Ente responsabile", "value":""},
            {"id":"pr_data", "label":"Data", "value":""},
            {"id":"pr_opaut", "label":"Operatori autorizzati", "value":""},
        ]
    },
     {
        "label":"Informazioni sul luogo di intervento",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_nome", "label":"Nome", "value":""},
            {"id":"pr_coordx", "label":"Coordinata X", "value":"", "cx":"true"},
	    {"id":"pr_coordy", "label":"Coordinata Y", "value":"", "cy":"true"},
            {"id":"pr_quota", "label":"Quota", "value":""},
            {"id":"pr_local", "label":"Localita'", "value":""},
            {"id":"pr_comune", "label":"Comune", "value":""},
            {"id":"pr_stato", "label":"Stato", "value":""},
            {"id":"pr_idmonsp", "label":"ID monitoraggio specie", "value":""},
            {"id":"pr_idmonhab", "label":"ID monitoraggio habitat", "value":""},
            {"id":"pr_idhabitat", "label":"ID habitat intervento", "value":""}
        ]
    },
     {
        "label":"Finalita' intervento",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_fin1", "label":"Allevamento ex situ", "value":"", "type":"checkbox"},
            {"id":"pr_fin2", "label":"Reintroduzione", "value":"", "type":"checkbox"},
            {"id":"pr_fin3", "label":"Ripopolamento", "value":"", "type":"checkbox"},
            {"id":"pr_fin4", "label":"Stoccaggio", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Destinazione individuo",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_des1", "label":"Insediamento in WMB", "value":"", "type":"checkbox"},
            {"id":"pr_des2", "label":"Insediamento in cavita'", "value":"", "type":"checkbox"},
            {"id":"pr_des3", "label":"Immissione acque lotiche", "value":"", "type":"checkbox"},
            {"id":"pr_des4", "label":"Immissione acque lentiche", "value":"", "type":"checkbox"},
            {"id":"pr_des5", "label":"Centro di allevamento", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Informazioni biologiche sull'esemplare",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_bio1", "label":"Stadio di sviluppo - adulto maturo", "value":"", "type":"checkbox"},
            {"id":"pr_bio2", "label":"Stadio di sviluppo - adulto immaturo", "value":"", "type":"checkbox"},
            {"id":"pr_bio3", "label":"Stadio di sviluppo - larva L1", "value":"", "type":"checkbox"},
            {"id":"pr_bio4", "label":"Stadio di sviluppo - larva L2", "value":"", "type":"checkbox"},
            {"id":"pr_bio5", "label":"Stadio di sviluppo - larva L3", "value":"", "type":"checkbox"},
            {"id":"pr_bio6", "label":"Stadio di sviluppo - pupa", "value":"", "type":"checkbox"},
            {"id":"pr_bio7", "label":"Sesso - M", "value":"", "type":"checkbox"},
            {"id":"pr_bio8", "label":"Sesso - F", "value":"", "type":"checkbox"},
            {"id":"pr_bio9", "label":"Sesso - I", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Altro",
        "solotipo":"prelievo",
        "children":[
            {"id":"pr_altro1", "label":"Metodo di cattura", "value":""},
            {"id":"pr_altro2", "label":"Sigla", "value":""},
            {"id":"pr_altro3", "label":"Ricattura", "value":""},
            {"id":"pr_altro4", "label":"Trasporto", "value":""},
	    {"id":"pr_altrofoto", "label":"Foto", "value":""},
            {"id":"pr_altro5", "label":"Analisi genetiche", "value":"", "type":"checkbox"}
        ]
    },
    {
        "label":"Monitoraggio immissioni",
        "solotipo":"prelievo",
	"add":"true",
        "hidden":"true",
        "children":[
            {"id":"prmon_data", "label":"Data avvistamento/ricattura", "value":""},
            {"id":"prmon_loc", "label":"Localita' avvistamento/ricattura", "value":""},
            {"id":"prmon_idms", "label":"ID monitoraggio specie", "value":""},
            {"id":"prmon_idmh", "label":"ID monitoraggio intervento habitat", "value":""},
	    {"id":"prmon_idca", "label":"ID controllo allevamento", "value":""}
        ]
    },
     {
        "label":"",
        "solotipo":"captive",
        "children":[
	    {"id":"box_num", "label":"Box N.", "value":""},
	    {"id":"box_ente", "label":"Ente responsabile", "value":""},
	    {"id":"box_num", "label":"Box N.", "value":""},
            {"id":"box_op", "label":"Operatore del controllo", "value":""},
            {"id":"box_alim", "label":"Tipo di alimentazione", "value":""},
            {"id":"box_datacon", "label":"Data di controllo", "value":""},
            {"id":"box_umid", "label":"Umidita' del locale", "value":""}
            
        ]
    },
     {
        "label":"Provenienza fondatori",
        "solotipo":"captive",
        "add":"true",
        "children":[
            {"id":"box_prelievo", "label":"ID prelievo", "value":""},
            {"id":"box_dataprel", "label":"Data prelievo fondatori", "value":""},
            {"id":"box_datains", "label":"Data inserimento box", "value":""},
            {"id":"box_m", "label":"N. fondatori M inseriti", "value":""},
            {"id":"box_f", "label":"N. fondatori F inseriti", "value":""},
            {"id":"box_fc", "label":"Fondatrici captivate", "value":""},
            {"id":"box_fs", "label":"Fondatrici selvatiche", "value":""},
            {"id":"box_l", "label":"N. fondatori larve", "value":""}
        ]
    },
     {
        "label":"Osservazioni al controllo",
        "solotipo":"captive",
        "children":[
            {"id":"box_sfarf", "label":"N. sfarfallamenti", "value":""},
            {"id":"box_schiuse", "label":"N. schiuse", "value":""},
            {"id":"box_mortil", "label":"N. morti - larve", "value":""},
            {"id":"box_mortip", "label":"N. morti - pupe", "value":""},
            {"id":"box_mortia", "label":"N. morti - adulti", "value":""},
            {"id":"box_uova", "label":"N. uova", "value":""},
            {"id":"box_muffe", "label":"Presenza muffe", "value":"", "type":"checkbox"},
            {"id":"box_parassiti", "label":"Presenza parassiti", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Conteggio esemplari",
        "solotipo":"captive",
        "children":[
            {"id":"box_cm", "label":"Numero M", "value":""},
            {"id":"box_cf", "label":"Numero F", "value":""},
            {"id":"box_cl1", "label":"Numero L1", "value":""},
            {"id":"box_cl2", "label":"Numero L2", "value":""},
            {"id":"box_cl3", "label":"Numero L3", "value":""},
            {"id":"box_cpupe", "label":"Numero pupe", "value":""},
            {"id":"box_cuova", "label":"Numero uova", "value":""},
            {"id":"box_parassiti", "label":"Presenza parassiti", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Aumento ponderale",
        "solotipo":"captive",
        "children":[
            {"id":"box_pesol1", "label":"Peso tot L1", "value":""},
            {"id":"box_pesol2", "label":"Peso tot L2", "value":""},
            {"id":"box_pesol3", "label":"Peso tot L3", "value":""}
        ]
    },
     {
        "label":"Misurazioni esemplari",
        "solotipo":"captive",
        "add":"true",
        "children":[
            {"id":"box_mtipo", "label":"Tipo", "value":""},
            {"id":"box_msesso", "label":"Sesso", "value":""},
            {"id":"box_mpeso", "label":"Peso (gr)", "value":""},
            {"id":"box_mlungh", "label":"Lunghezza (mm)", "value":""}
        ]
    },
     {
        "label":"Operazioni eseguite",
        "solotipo":"captive",
        "children":[
            {"id":"box_op1", "label":"Spostamenti animali in altri contenitori", "value":"", "type":"checkbox"},
            {"id":"box_op2", "label":"Umidificazione terriccio", "value":"", "type":"checkbox"},
            {"id":"box_op3", "label":"Sostituzione o aggiunta lettiera e/o terriccio", "value":"", "type":"checkbox"},
            {"id":"box_op4", "label":"Conteggio animale e divisione in stadi", "value":"", "type":"checkbox"},
            {"id":"box_op5", "label":"eliminazione funghi e/o parassiti", "value":"", "type":"checkbox"},
            {"id":"box_op6", "label":"altre operazioni", "value":"", "type":"checkbox"}
        ]
    },
     {
        "label":"Altro",
        "solotipo":"captive",
        "children":[
            {"id":"box_notesalute", "label":"Annotazioni sullo stato di salute", "value":""},
            {"id":"box_notealtre", "label":"Altre annotazioni", "value":""},
            {"id":"box_idfoto", "label":"ID foto/video", "value":""},
            {"id":"box_notenote", "label":"Note", "value":""}
        ]
    }
]


    this.state = {
      submitting: false,
      error: false,
      menuTipo: [
        {value:"habitat",label:"Interventi sugli habitat"},
        {value:"prelievo",label:"Prelievi/immissioni"},
        {value:"captive",label:"Captive breeding"}
      ],
      menuSottotipo: [
        {value:"albero",label:"Albero"},
        {value:"lentica",label:"Zona umida lentica"},
        {value:"lotica",label:"Zona umida lotica"}
      ],
      tree: (props.data.intervento && props.data.intervento.info? JSON.parse(props.data.intervento.info) : JSON.parse(JSON.stringify(bigJim)))
    };
    this.onSubmit = this.onSubmit.bind(this);
  }

  aggiungiId(nodo,k) {
    var i
    if (nodo && nodo.children) {
      for (i=0; i<nodo.children.length; i++)
        this.aggiungiId(nodo.children[i],k)
    }
    if (nodo.id) nodo.id += k
    nodo.value=null
    nodo.add=null
    nodo.hidden=null
    nodo.wasHidden=null
  }

  aggiungiNodo = (parent,nodo) => {
    if (nodo.hidden) {
      nodo.hidden=null
      nodo.wasHidden=true
      nodo.delete=true
      this.setState({tree:this.state.tree})
      return

    } else {
      var copy = JSON.parse(JSON.stringify(nodo))
      copy.delete=true
      var prog = Math.floor(Math.random() * 10000000);
      this.aggiungiId(copy,prog)

      var index = 0
      var lista = (parent==this.state.tree?parent:parent.children)
      for (index=0; index<lista.length; index++) {
        if (lista[index]===nodo) {
          lista.splice(index+1,0,copy)
          this.setState({tree:this.state.tree})
          return
        }
      }
    }
    
    
  }

  eliminaNodo = (parent,nodo) => {
    if (nodo.wasHidden) {
      nodo.hidden=true
      nodo.wasHidden=null
      nodo.delete=null
      this.setState({tree:this.state.tree})
      return

    } else {

      var index = 0
      var lista = (parent==this.state.tree?parent:parent.children)
      for (index=0; index<lista.length; index++) {
        if (lista[index]===nodo) {
          lista.splice(index,1)
          this.setState({tree:this.state.tree})
          return
        }
      }
    }
    
    
  }


  renderField = (field,naked) => {
    return (
      <div className={naked?"":"form-group"}>
        <label htmlFor={field.id} className="mr-2">
          {field.label}
        </label>
        <input id={field.id} className={!field.type?"form-control":""} value={field.value} type={field.type?field.type:"text"} 
          onClick={field.type=="checkbox"?(e)=>{console.log('onClick '+e.target.checked);field.value=e.target.checked; this.setState({tree:this.state.tree})}:null}
          onChange={field.type=="checkbox"?null:(e) =>{console.log('onChange '+e.target);field.value=e.target.value; this.setState({tree:this.state.tree}) } }
          defaultChecked={field.type=="checkbox"?field.value:null}
          />
          
      </div>
    )
  }

  renderMultifield = (field) => {
    return (
      <div className="form-group">
        {field.children.map(subfield =>
          this.renderField(subfield,true)
        
        )}
      </div>
    )
  }

  renderAddButton = (parent,field) => {
    return(
      <button type="button" disabled={this.state.submitting} className="btn mr-2" onClick={(e) => this.aggiungiNodo(parent,field)}>
      AGGIUNGI
      </button>
    )
  }

  renderDeleteButton = (parent,field) => {
    return(
      <button type="button" disabled={this.state.submitting} className="btn mr-2" onClick={(e) => this.eliminaNodo(parent,field)}>
      ELIMINA
      </button>
    )
  }

  renderVariablePart = (tipo,sottotipo) => {
    if (!this.state.tree) return (<div>NO</div>)
    //console.log(i)

    return (
        <div>
            {this.state.tree.filter(item=>{return (!item.solotipo || item.solotipo==tipo) && (!item.solosottotipo || item.solosottotipo.indexOf(sottotipo)!==-1) }).map(section => 
            <div>
            	{section.label &&
                <div className="row">
                    <div className="col">
                        <h5>{section.label}
                        {section.add &&
                          this.renderAddButton(this.state.tree,section)
                        }
                        {section.delete &&
                          this.renderDeleteButton(this.state.tree,section)
                        }
                        </h5>
                    </div>
                </div>
		}
                {!section.hidden && section.children.map(field => 
                    <div className="row">
                      {field.add &&
                          this.renderAddButton(section,field)
                      }
                      {field.delete &&
                          this.renderDeleteButton(section,field)
                      }
              		    <div className="col-md-8">
                        {!field.hidden && (!field.type || field.type!=='multi') && this.renderField(field,false)}
                        {!field.hidden && field.type==='multi' && this.renderMultifield(field)}
                      </div>
                    </div>
                )

                }
            </div>

            )}
        </div>
    )
  }

	trovaCoordinate = (x,coord) => {
		var c = (coord?coord:{})
		if (x.value && x.cx) c.x = x.value
		if (x.value && x.cy) c.y = x.value
		if (x.children) {
			var i
			for (i=0; i<x.children.length; i++)
				c = this.trovaCoordinate(x.children[i],c)
		}
		return c
	}

  onSubmit(values) {

    const {client, submitMutation, data} = this.props;

    this.setState({submitting: true});

	  var nod = {children:this.state.tree}

    var c = this.trovaCoordinate(nod,null)

    let variables = {
      intervento: {
        ...values,
	coordinataX: c.x,
	coordinataY: c.y,
        specie: values.specie.id ? { id: values.specie.id, }: null,
        sitoNatura2000: values.sitoNatura2000 ? { id: values.sitoNatura2000[0].id } : null,
          info: JSON.stringify(this.state.tree)
      }
    };

    delete variables.intervento.__typename;

    if(data && data.id) {
      variables.intervento.id = data.id;
    }

    client.mutate({
      mutation: submitMutation,
      variables: variables,
    }).then(res => {
      this.props.data.refetch()
		this.setState({
                submitting: false,
            })
       if (!variables.intervento.id) window.location.href='/LifeEremitaWeb/interventi/'+res.data.updateIntervento.id+'/edit'
      /*if(this.props.onSubmitComplete) {
        this.props.onSubmitComplete();
      } else {
        this.props.history.goBack();
      }*/
    }).catch(err => {
      console.log(err);
      this.setState({
        submitting: false,
        error: true,
      });
    });
  }

  render() {
    const {
      data,
      readOnly,
      utenteSessione
    } = this.props;

    if(data && data.loading) {
      return(<Loading/>);
    }

	  //console.log('interventoForm')
    //console.log(this.props)
    

    return (
      <Form
        defaultValues={data.intervento ? {
          ...data.intervento,
          specie: data.intervento.specie ? findById(data.specieProgettos, data.intervento.specie.id): null,
          sitoNatura2000: data.intervento.sitoNatura2000 ? [data.intervento.sitoNatura2000]: null,
	//sitoNatura2000: data.intervento.sitoNatura2000 ? { id: data.intervento.sitoNatura2000[0].id } : null,
          tipo: this.state.tipo || data.intervento.tipo || 'habitat',
          sottotipo: this.state.sottotipo || data.intervento.sottotipo || 'albero'
        } : null}
        onSubmit={this.onSubmit}>
        {(formApi) => <form onSubmit={formApi.submitForm}>
          <div className="row">
            <div className="col">
              <div className="form-group">
                <label htmlFor="specie">Specie</label>
                <SpeciesChooser field="specie" id="specie" />
              </div>
            </div>
          </div>
          {!formApi.values.specie && <div className="row">
            <div className="col">
              <h5>Informazioni Generali</h5>
              <div className="text-muted">Seleziona una specie per proseguire</div>
            </div>
          </div>}
          {formApi.values.specie && <div>
            {false && <div className="row">
                <div className="col-md-6">
                    <div className="form-group">
                        <label htmlFor="checkbox-input-authorize" className="mr-2">Validato</label>
                        <Checkbox
                            field="validato"
                            id="checkbox-input-authorize"
                            disabled={utenteSessione.loading ||
                            utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.validateIntervento).length==0
                            }
                        />
                    </div>
                </div>
            </div>
            }
            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="tipo">Tipologia intervento</label>
                  <Select
                    readOnly={readOnly}
                    field="tipo"
                    id="tipo"
                    options={this.state.menuTipo}
                    className="form-control" />
                </div>
              </div>
            </div>
            {formApi.values.tipo=='habitat' &&
            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="sottotipo">Tipologia habitat</label>
                  <Select
                    readOnly={readOnly}
                    field="sottotipo"
                    id="sottotipo"
                    options={this.state.menuSottotipo}
                    className="form-control" />
                </div>
              </div>
            </div>
            }
            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="idScheda">{'prelievo'==formApi.values.tipo?'ID esemplare':('captive'==formApi.values.tipo?'ID controllo box':'ID intervento')}</label>
                  <Text
                    readOnly={readOnly}
                    field="idScheda"
                    id="idScheda"
                    type="text"
                    className="form-control" />
                </div>
              </div>
            </div>
	    {formApi.values.tipo!='captive' &&
            <div className="row">
              <div className="col-md-8">
                <div className="form-group">
                  <label htmlFor="sitoNatura2000">Sito Natura 2000</label>
                  <Typeahead
                    readOnly={readOnly}
                    dataQuery={sitoNatura2000SmartFilterQuery}
                    helpText={"Cerca un sito Natura 2000 per nome"}
                    searchText={"Ricerca in corso..."}
                    paginationText={"Mostra di pi..."}
                    emptyLabel={"Nessun sito trovato."}
                    promptText={"Scrivi per cercare..."}
                    labelKey={"nome"}
                    filterKey={"testo"}
                    resultKey={"sitoNatura2000SmartFilter"}
                    field="sitoNatura2000"
                    id="sitoNatura2000"
                    className="form-control"
                    placeholder={""} />
                </div>
              </div>
            </div>
	    }

            <div className="row">
              <div className="col-md-8">
                <div className="form-group">
                  <label htmlFor="rilevatori">Compilatore</label>
                  <Text field="rilevatori"
                        readOnly={readOnly}
                        id="rilevatori"
                        type="text"
                        className="form-control" />
                </div>
              </div>
            </div>
	    {false &&
            <div className="row">

              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="transetto">Transetto</label>
                  <Text readOnly={readOnly} id="transetto"
                        field="transetto"
                        type="text"
                        className="form-control" />
                </div>
              </div>
            </div>
	    }

	    {this.renderVariablePart(formApi.values.tipo,formApi.values.sottotipo)}

	    <div className="row">
                            <div className="col">
                                <h5>Allegati all'intervento</h5>
                            </div>

                        </div>

             {data.intervento && <InterventoDocumenti data={data}/>}
		 <br/>

            {this.state.submitting && <div className="row">
              <div className="col">
                <div className="text-info text-center">Caricamento in corso...</div>
              </div>
            </div>}

            {this.state.error && <div className="row">
              <div className="col">
                <div className="text-info text-center">Errore durante il salvataggio della scheda</div>
              </div>
            </div>}

            <div className="row">
              <div className="col">
                <button disabled={this.state.submitting} type="submit" className="btn btn-primary">
                  {data && data.intervento && data.intervento.id ? "SALVA SCHEDA" : "CREA NUOVA SCHEDA"}
                </button>
              </div>
            </div>
          </div>}
        </form>}
      </Form>);
  }
}

const InterventoForm = withRouter(withApollo(InterventoFormComponent));

InterventoForm.defaultProps = {};

InterventoForm.propTypes = {
  data: PropTypes.object,
  submitMutation: PropTypes.object.isRequired,
  errorMessage: PropTypes.string.isRequired,
  onSubmitComplete: PropTypes.func,
};

export default InterventoForm;



